<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

$conn = new mysqli("localhost", "root", "", "DEFMIS");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$search = $_GET['search'] ?? '';
$days = ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];

// Fetch Weekly Activities
$weekly_data = [];
foreach ($days as $day) {
    if ($search) {
        $stmt = $conn->prepare("SELECT time_slot, activity, speaker FROM church_schedule WHERE day = ? AND (activity LIKE ? OR speaker LIKE ?)");
        $like = "%$search%";
        $stmt->bind_param("sss", $day, $like, $like);
    } else {
        $stmt = $conn->prepare("SELECT time_slot, activity, speaker FROM church_schedule WHERE day = ?");
        $stmt->bind_param("s", $day);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    $weekly_data[$day] = $result->fetch_all(MYSQLI_ASSOC);
}

// Fetch Projects
$projects = $conn->query("SELECT * FROM church_projects ORDER BY id DESC");

// Fetch Sermons
$sermons = $conn->query("SELECT * FROM church_sermons ORDER BY id DESC");

// Fetch Yearly Plans
$plans = $conn->query("SELECT * FROM church_yearly_plans ORDER BY year DESC");
?>
<!DOCTYPE html>
<html>
<head>
  <title>Church Events</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body style="font-family:sans-serif; max-width:95%; margin:auto; padding:20px;">
  <div style="text-align:right;"><a href='logout.php' style="color:red;">Logout</a></div>
  <h2 style="text-align:center;">Church Weekly Schedule</h2>

  <!-- Search -->
  <form method="get" style="text-align:center; margin-bottom:30px;">
    <input type="text" name="search" placeholder="Search speaker or activity" value="<?=htmlspecialchars($search)?>" style="padding:8px; width:60%; max-width:400px;">
    <button type="submit" style="padding:8px 15px;">Search</button>
  </form>

  <!-- Horizontal Day Headers -->
  <div style="display:grid; grid-template-columns: repeat(7, 1fr); gap:15px; text-align:center; font-weight:bold; background:#eee; padding:10px; border-radius:8px;">
    <?php foreach ($days as $day): ?>
      <div><?= $day ?></div>
    <?php endforeach; ?>
  </div>

  <!-- Activities under each day -->
  <div style="display:grid; grid-template-columns: repeat(7, 1fr); gap:15px; margin-top:10px;">
    <?php foreach ($days as $day): ?>
      <div>
        <?php if (!empty($weekly_data[$day])): ?>
          <?php foreach ($weekly_data[$day] as $item): ?>
            <div style="border:1px solid #ccc; border-radius:8px; padding:10px; margin-bottom:10px;">
              <div style="font-weight:bold;"><?= $item['time_slot'] ?></div>
              <div style="margin:5px 0;"><?= $item['activity'] ?></div>
              <div style="font-size:13px; color:#666;">by <?= $item['speaker'] ?></div>
            </div>
          <?php endforeach; ?>
        <?php else: ?>
          <p style="color:gray;">No activities</p>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>

  <!-- Projects Section -->
  <h2 style="margin-top:40px; text-align:center;">Church Projects</h2>
  <div style="display:flex; flex-wrap:wrap; gap:20px; justify-content:center;">
    <?php while ($row = $projects->fetch_assoc()): ?>
      <div style="border:1px solid #ccc; border-radius:8px; padding:15px; width:300px;">
        <h4><?= $row['title'] ?></h4>
        <p><?= $row['description'] ?></p>
      </div>
    <?php endwhile; ?>
  </div>

  <!-- Sermons Section -->
  <h2 style="margin-top:40px; text-align:center;">Sermons</h2>
  <div style="display:flex; flex-wrap:wrap; gap:20px; justify-content:center;">
    <?php while ($row = $sermons->fetch_assoc()): ?>
      <div style="border:1px solid #ccc; border-radius:8px; padding:15px; width:300px;">
        <h4><?= $row['title'] ?></h4>
        <p><b>Speaker:</b> <?= $row['speaker'] ?></p>
        <p><?= $row['summary'] ?></p>
      </div>
    <?php endwhile; ?>
  </div>

  <!-- Yearly Plans Section -->
  <h2 style="margin-top:40px; text-align:center;">Yearly Plans</h2>
  <table style="width:100%; border-collapse:collapse;">
    <thead>
      <tr style="background:#eee;">
        <th style="padding:10px; border:1px solid #ccc;">Year</th>
        <th style="padding:10px; border:1px solid #ccc;">Goal</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($row = $plans->fetch_assoc()): ?>
        <tr>
          <td style="padding:10px; border:1px solid #ccc;"><?= $row['year'] ?></td>
          <td style="padding:10px; border:1px solid #ccc;"><?= $row['goal'] ?></td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</body>
</html>
