<?php
include('includes/header.php');

// already have $conn from header
$type   = $_GET['type']   ?? 'all';
$q      = trim($_GET['q'] ?? '');
$county = $_GET['county'] ?? '';
?>

<div class="container my-4">
  <h2>Search Results</h2>
  <p><strong>Type:</strong> <?= htmlspecialchars($type) ?></p>
  <p><strong>Query:</strong> <?= htmlspecialchars($q) ?></p>
  <p><strong>County:</strong> <?= htmlspecialchars($county) ?></p>
  <hr>

  <?php
  // For now we implement hospitals search; other types can be added later.
  if ($type === 'hospital' || $type === 'all') {
    echo "<h4>Hospitals</h4>";

    // build SQL
    $sql  = "SELECT id, hospital_name, county, town, address, phone FROM hospitals WHERE 1=1";
    $params = [];
    $types  = "";

    if ($q !== "") {
      $sql    .= " AND (hospital_name LIKE ? OR town LIKE ?)";
      $like    = "%{$q}%";
      $params[] = &$like;
      $params[] = &$like;
      $types   .= "ss";
    }

    if ($county !== "") {
      $sql     .= " AND county = ?";
      $params[] = &$county;
      $types   .= "s";
    }

    $stmt = $conn->prepare($sql);

    if ($types !== "") {
      array_unshift($params, $types);
      call_user_func_array([$stmt, 'bind_param'], $params);
    }

    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows > 0) {
      while ($row = $res->fetch_assoc()) {
        $id      = (int)$row['id'];
        $name    = htmlspecialchars($row['hospital_name']);
        $cty     = htmlspecialchars($row['county']);
        $town    = htmlspecialchars($row['town'] ?? '');
        $address = htmlspecialchars($row['address'] ?? '');
        $phone   = htmlspecialchars($row['phone'] ?? '');
        ?>
        <div class="card mb-2">
          <div class="card-body">
            <h5 class="card-title"><?= $name ?></h5>
            <p class="card-text">
              County: <?= $cty ?><br>
              Town: <?= $town ?><br>
              Address: <?= $address ?><br>
              Phone: <?= $phone ?>
            </p>
            <a href="hospital-details.php?id=<?= $id ?>" class="btn btn-sm btn-success">View Details</a>
          </div>
        </div>
        <?php
      }
    } else {
      echo "<p>No hospitals found matching your search.</p>";
    }
  } else {
    echo "<p>Search for type <strong>" . htmlspecialchars($type) . "</strong> is not yet implemented.</p>";
  }
  ?>

</div>

<?php include('includes/footer.php'); ?>

<!-- Bootstrap JS (CDN) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // Navbar search helpers again
  function goToCategory(page) {
    if (page !== "") {
      window.location.href = page;
    }
  }

  function submitSearch() {
    let type   = document.getElementById("searchType").value;
    let query  = document.getElementById("searchQuery").value.trim();
    let county = document.getElementById("searchCounty").value;

    if (query === "" && county === "") {
      alert("Please type something or choose a county to search.");
      return;
    }

    let url = "search.php?type=" + encodeURIComponent(type) +
              "&q=" + encodeURIComponent(query) +
              "&county=" + encodeURIComponent(county);

    window.location.href = url;
  }
</script>
