<?php
// callback_form.php

// Configuration
$recipient_email = "your-email@example.com"; // Change this to your email
$success_message = "Thank you! We'll contact you shortly.";
$error_message = "Sorry, there was an error. Please try again.";

// Initialize variables
$errors = [];
$success = false;

// Process form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Sanitize and validate inputs
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';
    $issue = isset($_POST['issue']) ? trim($_POST['issue']) : '';
    $comment = isset($_POST['comment']) ? trim($_POST['comment']) : '';
    $recaptcha_response = isset($_POST['g-recaptcha-response']) ? $_POST['g-recaptcha-response'] : '';
    
    // Validation
    if (empty($name)) {
        $errors[] = "Name is required";
    }
    
    if (empty($email)) {
        $errors[] = "Email is required";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email format";
    }
    
    if (empty($phone)) {
        $errors[] = "Phone number is required";
    }
    
    if (empty($issue)) {
        $errors[] = "Please select an issue/problem";
    }
    
    // Verify reCAPTCHA (optional - requires reCAPTCHA secret key)
    /*
    if (empty($recaptcha_response)) {
        $errors[] = "Please complete the reCAPTCHA";
    } else {
        $recaptcha_secret = "YOUR_RECAPTCHA_SECRET_KEY";
        $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
        $recaptcha_data = [
            'secret' => $recaptcha_secret,
            'response' => $recaptcha_response
        ];
        
        $recaptcha_verify = file_get_contents($recaptcha_url . '?' . http_build_query($recaptcha_data));
        $recaptcha_result = json_decode($recaptcha_verify);
        
        if (!$recaptcha_result->success) {
            $errors[] = "reCAPTCHA verification failed";
        }
    }
    */
    
    // If no errors, send email
    if (empty($errors)) {
        $subject = "New Callback Request - $issue";
        
        $message_body = "
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; }
                .container { padding: 20px; }
                .field { margin-bottom: 15px; }
                .label { font-weight: bold; color: #333; }
                .value { color: #555; }
            </style>
        </head>
        <body>
            <div class='container'>
                <h2>New Callback Request</h2>
                <div class='field'>
                    <span class='label'>Name:</span>
                    <span class='value'>" . htmlspecialchars($name) . "</span>
                </div>
                <div class='field'>
                    <span class='label'>Email:</span>
                    <span class='value'>" . htmlspecialchars($email) . "</span>
                </div>
                <div class='field'>
                    <span class='label'>Phone Number:</span>
                    <span class='value'>" . htmlspecialchars($phone) . "</span>
                </div>
                <div class='field'>
                    <span class='label'>Issue/Problem:</span>
                    <span class='value'>" . htmlspecialchars($issue) . "</span>
                </div>
                <div class='field'>
                    <span class='label'>Comment:</span>
                    <span class='value'>" . nl2br(htmlspecialchars($comment)) . "</span>
                </div>
            </div>
        </body>
        </html>
        ";
        
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: " . $email . "\r\n";
        $headers .= "Reply-To: " . $email . "\r\n";
        
        if (mail($recipient_email, $subject, $message_body, $headers)) {
            $success = true;
            // Clear form data
            $name = $email = $phone = $issue = $comment = '';
        } else {
            $errors[] = $error_message;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Request a Callback</title>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 40px;
            align-items: start;
        }
        
        .left-section h1 {
            font-size: 2.5rem;
            margin-bottom: 20px;
            color: #333;
        }
        
        .left-section p {
            font-size: 1rem;
            line-height: 1.6;
            color: #555;
            margin-bottom: 30px;
        }
        
        .left-section img {
            width: 100%;
            border-radius: 10px;
        }
        
        .form-section {
            background-color: #5a6b7a;
            padding: 40px;
            border-radius: 10px;
            color: white;
        }
        
        .form-section h2 {
            margin-bottom: 30px;
            font-size: 1.8rem;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-size: 0.95rem;
        }
        
        label .required {
            color: #ff6b6b;
        }
        
        input[type="text"],
        input[type="email"],
        select,
        textarea {
            width: 100%;
            padding: 12px 15px;
            border: none;
            border-radius: 5px;
            font-size: 1rem;
            font-family: Arial, sans-serif;
        }
        
        textarea {
            min-height: 100px;
            resize: vertical;
        }
        
        select {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23333' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 15px center;
            cursor: pointer;
        }
        
        .submit-btn {
            width: 100%;
            padding: 15px;
            background-color: #dc2626;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 1.1rem;
            font-weight: bold;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .submit-btn:hover {
            background-color: #b91c1c;
        }
        
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        
        .alert-success {
            background-color: #10b981;
            color: white;
        }
        
        .alert-error {
            background-color: #ef4444;
            color: white;
        }
        
        .alert ul {
            margin-left: 20px;
        }
        
        @media (max-width: 768px) {
            .container {
                grid-template-columns: 1fr;
            }
            
            .form-row {
                grid-template-columns: 1fr;
            }
            
            .left-section h1 {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="left-section">
            <h1>Request a Callback</h1>
            <p>Fill out the form below and one of our experienced representatives will reach out to you shortly. Whether you have questions about your policy, need assistance with a claim, or want to explore new insurance options, we are here to help.</p>
            <img src="representative.jpg" alt="Customer Service Representative">
        </div>
        
        <div class="form-section">
            <h2>Request for a callback</h2>
            
            <?php if ($success): ?>
                <div class="alert alert-success">
                    <?php echo $success_message; ?>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($errors)): ?>
                <div class="alert alert-error">
                    <ul>
                        <?php foreach ($errors as $error): ?>
                            <li><?php echo htmlspecialchars($error); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                <div class="form-row">
                    <div class="form-group">
                        <label>Name <span class="required">*</span></label>
                        <input type="text" name="name" placeholder="John Doe" value="<?php echo htmlspecialchars($name ?? ''); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Email <span class="required">*</span></label>
                        <input type="email" name="email" placeholder="example@example.com" value="<?php echo htmlspecialchars($email ?? ''); ?>" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Phone Number <span class="required">*</span></label>
                        <input type="text" name="phone" placeholder="07xx or 01xx" value="<?php echo htmlspecialchars($phone ?? ''); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Issue/Problem <span class="required">*</span></label>
                        <select name="issue" required>
                            <option value="">Claims</option>
                            <option value="Claims" <?php echo (isset($issue) && $issue == 'Claims') ? 'selected' : ''; ?>>Claims</option>
                            <option value="Policy Question" <?php echo (isset($issue) && $issue == 'Policy Question') ? 'selected' : ''; ?>>Policy Question</option>
                            <option value="New Insurance" <?php echo (isset($issue) && $issue == 'New Insurance') ? 'selected' : ''; ?>>New Insurance</option>
                            <option value="Billing" <?php echo (isset($issue) && $issue == 'Billing') ? 'selected' : ''; ?>>Billing</option>
                            <option value="Other" <?php echo (isset($issue) && $issue == 'Other') ? 'selected' : ''; ?>>Other</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Comment</label>
                    <textarea name="comment" placeholder="Enter your message here..."><?php echo htmlspecialchars($comment ?? ''); ?></textarea>
                </div>
                
                <div class="form-group">
                    <div class="g-recaptcha" data-sitekey="YOUR_RECAPTCHA_SITE_KEY"></div>
                </div>
                
                <button type="submit" class="submit-btn">Submit</button>
            </form>
        </div>
    </div>
</body>
</html>