<?php include('includes/header.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Why Choose Us | Twin Beam Enterprises</title>

<style>
/* =====================
   BRAND VARIABLES
===================== */
:root {
    --primary: #1e88e5;
    --secondary: #0d47a1;
    --accent: #00c853;
    --dark: #0b1220;
    --light: #f5f7fb;
    --card: #ffffff;
}

/* RESET */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', Tahoma, sans-serif;
    background: var(--light);
    color: #333;
}

/* CONTAINER */
.wrapper {
    max-width: 1200px;
    margin: auto;
}

/* =====================
   HERO
===================== */
.hero {
    background: linear-gradient(135deg, var(--secondary), var(--primary));
    color: #fff;
    padding: 110px 20px;
}

.hero-inner {
    max-width: 1000px;
    margin: auto;
    text-align: center;
}

.hero h1 {
    font-size: 3.2rem;
    margin-bottom: 20px;
}

.hero p {
    font-size: 1.35rem;
    opacity: .95;
}

/* =====================
   SECTION BLOCKS
===================== */
.section {
    padding: 90px 20px;
}

.section.alt {
    background: #fff;
}

.block {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: center;
    max-width: 1100px;
    margin: auto;
}

.block.reverse {
    direction: rtl;
}

.block.reverse * {
    direction: ltr;
}

/* IMAGE */
.block-image {
    border-radius: 18px;
    overflow: hidden;
    box-shadow: 0 20px 50px rgba(0,0,0,.15);
}

.block-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* CONTENT */
.block-content h2 {
    font-size: 2.4rem;
    color: var(--secondary);
    margin-bottom: 20px;
}

.block-content p {
    font-size: 1.15rem;
    line-height: 1.8;
    margin-bottom: 25px;
}

.block-content ul {
    list-style: none;
}

.block-content li {
    margin-bottom: 12px;
    font-size: 1.05rem;
}

.block-content li::before {
    content: "✔";
    color: var(--accent);
    margin-right: 10px;
}

/* =====================
   FEATURE GRID
===================== */
.features {
    max-width: 1100px;
    margin: auto;
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 35px;
}

.feature {
    background: var(--card);
    padding: 40px 30px;
    border-radius: 18px;
    box-shadow: 0 12px 30px rgba(0,0,0,.1);
    text-align: center;
}

.feature span {
    font-size: 2.6rem;
    color: var(--primary);
}

.feature h3 {
    margin: 20px 0 15px;
    font-size: 1.4rem;
}

.feature p {
    font-size: 1.05rem;
    line-height: 1.7;
}

/* =====================
   CTA
===================== */
.cta {
    background: linear-gradient(135deg, var(--dark), #020617);
    color: #fff;
    padding: 90px 20px;
    text-align: center;
}

.cta h2 {
    font-size: 2.6rem;
    margin-bottom: 20px;
}

.cta p {
    font-size: 1.25rem;
    max-width: 700px;
    margin: auto auto 40px;
}

.cta a {
    background: var(--accent);
    color: #022c22;
    padding: 18px 45px;
    text-decoration: none;
    font-weight: 700;
    border-radius: 50px;
}

/* =====================
   FOOTER
===================== */
.footer {
    background: #020617;
    color: #9ca3af;
    padding: 50px 20px;
    text-align: center;
}

/* =====================
   RESPONSIVE
===================== */
@media(max-width: 900px) {
    .block,
    .features {
        grid-template-columns: 1fr;
    }

    .hero h1 {
        font-size: 2.4rem;
    }
}
</style>
</head>

<body>

<section class="hero">
    <div class="hero-inner">
        <h1>Why Choose Twin Beam Enterprises</h1>
        <p>Structured solutions. Reliable delivery. Long-term partnerships.</p>
    </div>
</section>

<section class="section">
    <div class="block">
        <div class="block-image">
            <img src="img/icon/tag3.jpeg" alt="">
        </div>
        <div class="block-content">
            <h2>Built Around Your Business</h2>
            <p>
                We focus on understanding your operational challenges and
                delivering solutions that improve efficiency, security,
                and scalability.
            </p>
            <ul>
                <li>Client-focused approach</li>
                <li>Scalable solutions</li>
                <li>Reliable support</li>
            </ul>
        </div>
    </div>
</section>

<section class="section alt">
    <div class="block reverse">
        <div class="block-image">
            <img src="img/icon/tag8.jpeg" alt="">
        </div>
        <div class="block-content">
            <h2>Professional & Ethical</h2>
            <p>
                We operate with integrity, transparency, and a strong sense
                of accountability across all engagements.
            </p>
        </div>
    </div>
</section>

<section class="section">
    <div class="block">
        <div class="block-image">
            <img src="img/icon/tag10.jpeg" alt="">
        </div>
        <div class="block-content">
            <h2>Technology That Works</h2>
            <p>
                From asset tagging to IT infrastructure, our solutions
                are practical, tested, and built for real-world use.
            </p>
        </div>
    </div>
</section>

<section class="section alt">
    <div class="features">
        <div class="feature">
            <span>⚙️</span>
            <h3>Tailored Solutions</h3>
            <p>Designed specifically for your operational needs.</p>
        </div>
        <div class="feature">
            <span>🛡️</span>
            <h3>Trusted Processes</h3>
            <p>Proven methods that reduce risk and maximize ROI.</p>
        </div>
        <div class="feature">
            <span>🤝</span>
            <h3>Long-Term Partner</h3>
            <p>We grow with your business over time.</p>
        </div>
    </div>
</section>

</body>
</html>

<?php include('includes/footer.php'); ?>
