<?php include('includes/header.php'); ?>
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

<style>
.hero-section {
  position: relative;
  height: 300px;
  background: url('img/church-hero.jpg') center center/cover no-repeat;
}
.hero-section .overlay {
  position: absolute;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.6);
}
.hero-section .breadcrumb {
  background: transparent;
  margin-top: 15px;
}
.hero-section .breadcrumb-item + .breadcrumb-item::before {
  color: #ffffff;
}
.section-hr {
  border: 1px solid #fff;
  opacity: 1;
  width: 100px;
  margin: 20px auto;
}
.fade-in {
  opacity: 0;
  animation: fadeIn 1.2s ease forwards;
}
@keyframes fadeIn {
  to {
    opacity: 1;
  }
}
</style>

<!-- HERO SECTION -->
<section class="hero-section text-center text-white d-flex align-items-center justify-content-center">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-5 fw-bold">Welcome to Our Church</h1>
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-center">
        <li class="breadcrumb-item"><a href="index.php" class="text-white text-decoration-underline">Home</a></li>
        <li class="breadcrumb-item active text-white" aria-current="page">Church Landing</li>
      </ol>
    </nav>
  </div>
</section>

<<!-- Men Department Leadership Section -->
<div style="margin-top: 50px;">
  <h2 style="text-align: center; color: #004080; margin-bottom: 20px;">Men's Department Leadership Team</h2>

  <div style="display: flex; flex-wrap: wrap; gap: 20px; justify-content: center;">
    
    <!-- Leader Cards -->
    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
       <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Chairman</h4>
      <strong style="color: #333;">Mr. John Mwangi</strong>
      <p style="font-size: 13px; color: #555;">Oversees all departmental activities and provides spiritual leadership to the men.</p>
    </div>

    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
      <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Assistant Chairman</h4>
      <strong style="color: #333;">Mr. Peter Otieno</strong>
      <p style="font-size: 13px; color: #555;">Supports the chairman and steps in when he is unavailable.</p>
    </div>

    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
      <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Secretary</h4>
      <strong style="color: #333;">Mr. James Kimani</strong>
      <p style="font-size: 13px; color: #555;">Handles minutes, records, and communication for the department.</p>
    </div>

    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
       <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Assistant Secretary</h4>
      <strong style="color: #333;">Mr. David Oloo</strong>
      <p style="font-size: 13px; color: #555;">Supports documentation and ensures smooth communication.</p>
    </div>

    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
      <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Treasurer</h4>
      <strong style="color: #333;">Mr. Samuel Kariuki</strong>
      <p style="font-size: 13px; color: #555;">Manages departmental finances and gives reports during meetings.</p>
    </div>

    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
      <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Prayer Coordinator</h4>
      <strong style="color: #333;">Mr. Elijah Mumo</strong>
      <p style="font-size: 13px; color: #555;">Leads prayer sessions and spiritual intercession for men’s growth.</p>
    </div>

    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
     <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Welfare Coordinator</h4>
      <strong style="color: #333;">Mr. Stephen Njuguna</strong>
      <p style="font-size: 13px; color: #555;">Coordinates care and support during celebrations and challenges.</p>
    </div>

    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
      <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Evangelism/Outreach</h4>
      <strong style="color: #333;">Mr. Joseph Odhiambo</strong>
      <p style="font-size: 13px; color: #555;">Organizes outreach programs and evangelistic missions.</p>
    </div>

    <div style="flex: 1 1 250px; border: 1px solid #ccc; border-radius: 8px; padding: 15px; text-align: center;">
      <img src="img/sider/filler.jpg" alt="Card image" style="width: 100%; margin: 10px 0;">
      <h4 style="margin: 5px 0; color: #004080;">Discipleship & Mentorship</h4>
      <strong style="color: #333;">Mr. Fredrick Mutua</strong>
      <p style="font-size: 13px; color: #555;">Guides spiritual maturity and growth through mentoring younger men.</p>
    </div>

  </div>
</div>


<div style="max-width: 1300px; margin: 30px auto; padding: 25px; background-color: #f1f7ff; border-left: 6px solid #004080; border-right: 6px solid #004080; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); font-family: Arial, sans-serif;">
  <h3 style="color: #004080; margin-top: 0;">Mission & Objectives</h3>
  <ul style="color: #333; line-height: 1.7; padding-left: 20px; margin: 0;">
    <li>To nurture and equip men spiritually to grow in faith and leadership.To encourage active participation of men in church programs and ministries.</li>
    <li>To encourage active participation of men in church programs and ministries.</li>
    <li>To foster brotherhood and mutual support among the men of the church.</li>
    <li>To organize seminars, workshops, and retreats focused on godly manhood, marriage, parenting, and finance.</li>
    <li>To reach out to the unsaved through evangelism and community outreach.</li>
  </ul>
</div>




<div style="max-width: 1300px; margin: 30px auto; padding: 25px; background-color: #fff9f0; border-left: 6px solid #ff9900; border-right: 6px solid #ff9900; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.05); font-family: Arial, sans-serif;">
  <h3 style="color: #004080; margin-top: 0;">Programs & Activities</h3>
  <ul style="color: #333; line-height: 1.7; padding-left: 20px; margin: 0;">
    <li>Monthly Men’s Fellowship</li>
    <li>Quarterly Leadership Training Sessions</li>
    <li>Annual Men’s Conference</li>
    <li>Evangelism & Mission Work</li>
    <li>Welfare Visits (e.g. hospitals, bereaved families, elderly members)</li>
    <li>Men’s Sports Day & Team Building</li>
    <li>Men’s Sunday – where men lead the entire church service</li>
  </ul>
</div>




<div style="max-width: 1300px; margin: 30px auto; padding: 25px; background-color: #e9fcef; border-left: 6px solid #2e8b57; border-right: 6px solid #2e8b57; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.05); font-family: Arial, sans-serif;">
  <h3 style="color: #004080; margin-top: 0;">Membership</h3>
  <p style="color: #333; line-height: 1.7; margin: 0;">
    All male members of the church aged 18 years and above are automatically members of the Men’s Department. Active participation is encouraged to grow in faith, service, and brotherhood.
  </p>
</div>


  <div style="margin-top: 30px;">
  <h3 style="color: #004080;">Upcoming Events</h3>

  <table style="width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 14px;">
    <thead>
      <tr style="background-color: #004080; color: #ffffff;">
        <th style="padding: 10px; text-align: left;">Date</th>
        <th style="padding: 10px; text-align: left;">Event</th>
        <th style="padding: 10px; text-align: left;">Venue</th>
        <th style="padding: 10px; text-align: left;">Time</th>
      </tr>
    </thead>
    <tbody>
      <tr style="background-color: #f2f2f2;">
        <td style="padding: 10px;">Sat, Aug 17, 2025</td>
        <td style="padding: 10px;">Monthly Men’s Fellowship</td>
        <td style="padding: 10px;">Church Hall</td>
        <td style="padding: 10px;">4:00 PM - 6:00 PM</td>
      </tr>
      <tr>
        <td style="padding: 10px;">Sun, Sept 1, 2025</td>
        <td style="padding: 10px;">Men’s Sunday (Men lead entire service)</td>
        <td style="padding: 10px;">Main Sanctuary</td>
        <td style="padding: 10px;">8:30 AM - 12:30 PM</td>
      </tr>
      <tr style="background-color: #f2f2f2;">
        <td style="padding: 10px;">Oct 12-13, 2025</td>
        <td style="padding: 10px;">Men’s Retreat (Spiritual & Leadership)</td>
        <td style="padding: 10px;">Faith & Fire Prayer Centre</td>
        <td style="padding: 10px;">Full Day (Overnight)</td>
      </tr>
      <tr>
        <td style="padding: 10px;">Nov 9, 2025</td>
        <td style="padding: 10px;">Community Outreach (Hospital Visit)</td>
        <td style="padding: 10px;">St. Mary’s Hospital</td>
        <td style="padding: 10px;">2:00 PM - 5:00 PM</td>
      </tr>
    </tbody>
  </table>
</div>

  <h2 style="text-align:center; margin-bottom:20px; color:#333;">
    STANDARD DEVELOPMENT / REVIEW PROCESS
  </h2>

  <div style="display:flex; flex-direction:column; gap:10px; max-width:1200px; margin:auto;">

    <!-- 1. Identify Need -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#1A4C8B; color:#fff; padding:15px; width:200px; font-weight:bold;">1. IDENTIFY NEED</div>
      <div style="background:#f5faff; padding:15px; flex:1;">
        • An individual or unit determines need for standard <br>
        • At least one responsible executive agrees to sponsor standard
      </div>
    </div>

    <!-- 2. Draft -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#1A4C8B; color:#fff; padding:15px; width:200px; font-weight:bold;">2. DRAFT</div>
      <div style="background:#f5faff; padding:15px; flex:1;">
        • Responsible office appoints responsible official(s) to develop draft <br>
        • Responsible office consults with University Policy Office (UPO) to ensure draft is in required format
      </div>
    </div>

    <!-- 3. Stakeholder Input -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#1A4C8B; color:#fff; padding:15px; width:200px; font-weight:bold;">3. STAKEHOLDER INPUT</div>
      <div style="background:#f5faff; padding:15px; flex:1;">
        • Responsible office shares standard draft with stakeholders <br>
        • Responsible office incorporates stakeholder feedback into standard draft
      </div>
    </div>

    <!-- 4. Legal Review -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#8B1C1C; color:#fff; padding:15px; width:200px; font-weight:bold;">4. LEGAL REVIEW</div>
      <div style="background:#fff5f5; padding:15px; flex:1;">
        • UPO obtains legal review of standard as necessary <br>
        • Responsible office incorporates legal feedback into standard draft
      </div>
    </div>

    <!-- 5. Approval -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#8B1C1C; color:#fff; padding:15px; width:200px; font-weight:bold;">5. APPROVAL</div>
      <div style="background:#fff5f5; padding:15px; flex:1;">
        • UPO distributes standard draft to VPRC <br>
        • VPRC may approve standard
      </div>
    </div>

    <!-- 6. Communicate -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#2E7D32; color:#fff; padding:15px; width:200px; font-weight:bold;">6. COMMUNICATE</div>
      <div style="background:#f5fff5; padding:15px; flex:1;">
        • UPO posts standard to University web and issues announcement of standard <br>
        • Responsible office develops additional support systems as needed
      </div>
    </div>

    <!-- 7. Training and Compliance -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#2E7D32; color:#fff; padding:15px; width:200px; font-weight:bold;">7. TRAINING AND COMPLIANCE</div>
      <div style="background:#f5fff5; padding:15px; flex:1;">
        • Responsible office creates additional required communication or training for standard <br>
        • Responsible office ensures compliance
      </div>
    </div>

    <!-- 8. Review and Update -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#2E7D32; color:#fff; padding:15px; width:200px; font-weight:bold;">8. REVIEW AND UPDATE</div>
      <div style="background:#f5fff5; padding:15px; flex:1;">
        • Responsible office initiates revision of standard by repeating steps 2–5 as needed <br>
        • Responsible office notifies UPO of update/revision to standard
      </div>
    </div>

    <!-- 9. Archive -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden;">
      <div style="background:#2E7D32; color:#fff; padding:15px; width:200px; font-weight:bold;">9. ARCHIVE</div>
      <div style="background:#f5fff5; padding:15px; flex:1;">
        • UPO transfers retired or superseded standards to archived location
      </div>
    </div>

  </div>


  <h2 style="text-align:center; margin-bottom:20px; color:#333;">
    STANDARD DEVELOPMENT / REVIEW PROCESS
  </h2>

  <div style="display:flex; flex-direction:column; align-items:center; gap:15px; max-width:1200px; margin:auto;">

    <!-- 1. Identify Need -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#1A4C8B; color:#fff; padding:15px; width:200px; font-weight:bold;">1. IDENTIFY NEED</div>
      <div style="background:#f5faff; padding:15px; flex:1;">
        • An individual or unit determines need for standard <br>
        • At least one responsible executive agrees to sponsor standard
      </div>
    </div>

    <!-- Arrow -->
    <div style="font-size:28px; color:#555;">&#8595;</div>

    <!-- 2. Draft -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#1A4C8B; color:#fff; padding:15px; width:200px; font-weight:bold;">2. DRAFT</div>
      <div style="background:#f5faff; padding:15px; flex:1;">
        • Responsible office appoints responsible official(s) to develop draft <br>
        • Responsible office consults with University Policy Office (UPO) to ensure draft is in required format
      </div>
    </div>

    <!-- Arrow -->
    <div style="font-size:28px; color:#555;">&#8595;</div>

    <!-- 3. Stakeholder Input -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#1A4C8B; color:#fff; padding:15px; width:200px; font-weight:bold;">3. STAKEHOLDER INPUT</div>
      <div style="background:#f5faff; padding:15px; flex:1;">
        • Responsible office shares standard draft with stakeholders <br>
        • Responsible office incorporates stakeholder feedback into standard draft
      </div>
    </div>

    <!-- Arrow -->
    <div style="font-size:28px; color:#555;">&#8595;</div>

    <!-- 4. Legal Review -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#8B1C1C; color:#fff; padding:15px; width:200px; font-weight:bold;">4. LEGAL REVIEW</div>
      <div style="background:#fff5f5; padding:15px; flex:1;">
        • UPO obtains legal review of standard as necessary <br>
        • Responsible office incorporates legal feedback into standard draft
      </div>
    </div>

    <!-- Arrow -->
    <div style="font-size:28px; color:#555;">&#8595;</div>

    <!-- 5. Approval -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#8B1C1C; color:#fff; padding:15px; width:200px; font-weight:bold;">5. APPROVAL</div>
      <div style="background:#fff5f5; padding:15px; flex:1;">
        • UPO distributes standard draft to VPRC <br>
        • VPRC may approve standard
      </div>
    </div>

    <!-- Arrow -->
    <div style="font-size:28px; color:#555;">&#8595;</div>

    <!-- 6. Communicate -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#2E7D32; color:#fff; padding:15px; width:200px; font-weight:bold;">6. COMMUNICATE</div>
      <div style="background:#f5fff5; padding:15px; flex:1;">
        • UPO posts standard to University web and issues announcement of standard <br>
        • Responsible office develops additional support systems as needed
      </div>
    </div>

    <!-- Arrow -->
    <div style="font-size:28px; color:#555;">&#8595;</div>

    <!-- 7. Training and Compliance -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#2E7D32; color:#fff; padding:15px; width:200px; font-weight:bold;">7. TRAINING AND COMPLIANCE</div>
      <div style="background:#f5fff5; padding:15px; flex:1;">
        • Responsible office creates additional required communication or training for standard <br>
        • Responsible office ensures compliance
      </div>
    </div>

    <!-- Arrow -->
    <div style="font-size:28px; color:#555;">&#8595;</div>

    <!-- 8. Review and Update -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#2E7D32; color:#fff; padding:15px; width:200px; font-weight:bold;">8. REVIEW AND UPDATE</div>
      <div style="background:#f5fff5; padding:15px; flex:1;">
        • Responsible office initiates revision of standard by repeating steps 2–5 as needed <br>
        • Responsible office notifies UPO of update/revision to standard
      </div>
    </div>

    <!-- Arrow -->
    <div style="font-size:28px; color:#555;">&#8595;</div>

    <!-- 9. Archive -->
    <div style="display:flex; border:1px solid #ccc; border-radius:4px; overflow:hidden; width:100%;">
      <div style="background:#2E7D32; color:#fff; padding:15px; width:200px; font-weight:bold;">9. ARCHIVE</div>
      <div style="background:#f5fff5; padding:15px; flex:1;">
        • UPO transfers retired or superseded standards to archived location
      </div>
    </div>

  </div>




   <!-- Title -->
  <h2 style="text-align:left; margin:20px; font-size:26px; color:#fff; font-weight:bold;">
    WEALTH MANAGEMENT
  </h2>

  <!-- Wire Line -->
  <div style="width:100%; height:4px; background:#fff; position:relative; top:30px; z-index:0;"></div>

  <!-- Container -->
  <div style="display:flex; justify-content:center; align-items:flex-start; padding:60px 20px 20px; gap:15px; position:relative; z-index:1;">

    <!-- Column 1 -->
    <div style="position:relative; background:#f39c12; width:180px; border-radius:0 0 100px 100px; padding:60px 20px 30px; text-align:center;">
      <!-- Wire Hook -->
      <div style="width:0; height:0; border-left:12px solid transparent; border-right:12px solid transparent; border-bottom:15px solid #f39c12; position:absolute; top:-15px; left:calc(50% - 12px);"></div>
      <!-- Number bar -->
      <div style="position:absolute; top:0; left:0; right:0; background:#e67e22; height:40px; border-radius:5px 5px 0 0; font-weight:bold; display:flex; align-items:center; justify-content:center;">
        01
      </div>
      <h3 style="margin:50px 0 10px; font-size:16px;">Financial Planning</h3>
      <p style="font-size:13px; line-height:1.5;">
        Cash Flows & Budgeting Analysis <br>
        Pre & Post Retirement Planning <br>
        Goal Setting & Prioritization
      </p>
    </div>

    <!-- Column 2 -->
    <div style="position:relative; background:#e74c3c; width:180px; border-radius:0 0 100px 100px; padding:60px 20px 30px; text-align:center;">
      <div style="width:0; height:0; border-left:12px solid transparent; border-right:12px solid transparent; border-bottom:15px solid #e74c3c; position:absolute; top:-15px; left:calc(50% - 12px);"></div>
      <div style="position:absolute; top:0; left:0; right:0; background:#c0392b; height:40px; border-radius:5px 5px 0 0; font-weight:bold; display:flex; align-items:center; justify-content:center;">
        02
      </div>
      <h3 style="margin:50px 0 10px; font-size:16px;">Investment Management</h3>
      <p style="font-size:13px; line-height:1.5;">
        Global Diversification <br>
        Mutual Fund Allocation <br>
        Portfolio Monitoring <br>
        Rebalancing <br>
        Developing Investment Strategies
      </p>
    </div>

    <!-- Column 3 -->
    <div style="position:relative; background:#2980b9; width:180px; border-radius:0 0 100px 100px; padding:60px 20px 30px; text-align:center;">
      <div style="width:0; height:0; border-left:12px solid transparent; border-right:12px solid transparent; border-bottom:15px solid #2980b9; position:absolute; top:-15px; left:calc(50% - 12px);"></div>
      <div style="position:absolute; top:0; left:0; right:0; background:#21618c; height:40px; border-radius:5px 5px 0 0; font-weight:bold; display:flex; align-items:center; justify-content:center;">
        03
      </div>
      <h3 style="margin:50px 0 10px; font-size:16px;">Tax Planning</h3>
      <p style="font-size:13px; line-height:1.5;">
        Income Tax Planning <br>
        Strategic Tax Savings <br>
        Tax Credits & Deductions <br>
        2023 New Tax-Free Strategies
      </p>
    </div>

    <!-- Column 4 -->
    <div style="position:relative; background:#27ae60; width:180px; border-radius:0 0 100px 100px; padding:60px 20px 30px; text-align:center;">
      <div style="width:0; height:0; border-left:12px solid transparent; border-right:12px solid transparent; border-bottom:15px solid #27ae60; position:absolute; top:-15px; left:calc(50% - 12px);"></div>
      <div style="position:absolute; top:0; left:0; right:0; background:#1e8449; height:40px; border-radius:5px 5px 0 0; font-weight:bold; display:flex; align-items:center; justify-content:center;">
        04
      </div>
      <h3 style="margin:50px 0 10px; font-size:16px;">Estate Planning</h3>
      <p style="font-size:13px; line-height:1.5;">
        Lifetime Tax Planning <br>
        Gifting Strategies <br>
        Charitable Planning <br>
        Trust Formation <br>
        Estate Administration
      </p>
    </div>

    <!-- Column 5 -->
    <div style="position:relative; background:#16a085; width:180px; border-radius:0 0 100px 100px; padding:60px 20px 30px; text-align:center;">
      <div style="width:0; height:0; border-left:12px solid transparent; border-right:12px solid transparent; border-bottom:15px solid #16a085; position:absolute; top:-15px; left:calc(50% - 12px);"></div>
      <div style="position:absolute; top:0; left:0; right:0; background:#117a65; height:40px; border-radius:5px 5px 0 0; font-weight:bold; display:flex; align-items:center; justify-content:center;">
        05
      </div>
      <h3 style="margin:50px 0 10px; font-size:16px;">Business Planning</h3>
      <p style="font-size:13px; line-height:1.5;">
        Defined Contribution Plan <br>
        Business Exit Planning <br>
        Risk & Liability Management <br>
        Business Valuation
      </p>
    </div>

    <!-- Column 6 -->
    <div style="position:relative; background:#8e44ad; width:180px; border-radius:0 0 100px 100px; padding:60px 20px 30px; text-align:center;">
      <div style="width:0; height:0; border-left:12px solid transparent; border-right:12px solid transparent; border-bottom:15px solid #8e44ad; position:absolute; top:-15px; left:calc(50% - 12px);"></div>
      <div style="position:absolute; top:0; left:0; right:0; background:#6c3483; height:40px; border-radius:5px 5px 0 0; font-weight:bold; display:flex; align-items:center; justify-content:center;">
        06
      </div>
      <h3 style="margin:50px 0 10px; font-size:16px;">Risk Management</h3>
      <p style="font-size:13px; line-height:1.5;">
        Asset Protection <br>
        Managing Concentrated Positions <br>
        Insurance Solutions <br>
        Business Risk Management
      </p>
    </div>

  </div>



   <!-- Title -->
  <h2 style="text-align:center; color:#fff; padding:20px; margin:0;">WEALTH MANAGEMENT</h2>

  <!-- Wire -->
  <div style="width:100%; height:5px; background:#fff; position:relative; margin:20px 0;"></div>

  <!-- Container for Hanging Tabs -->
  <div style="display:flex; justify-content:center; align-items:flex-start; gap:20px; margin-top:-10px;">

    <!-- Tab 1 -->
    <div style="width:200px; background:#f4a21a; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#e67e00; color:#fff; padding:5px; border-radius:20px; display:inline-block;">01</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Financial Planning<br>Cash Flow & Budgeting<br>Risk & Debt Management<br>Retirement Planning<br>Goal Setting & Prioritization
      </p>
    </div>

    <!-- Tab 2 -->
    <div style="width:200px; background:#e94f37; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#b32719; color:#fff; padding:5px; border-radius:20px; display:inline-block;">02</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Investment Management<br>Global Diversification<br>Asset Allocation<br>Portfolio Monitoring<br>Rebalancing<br>Investment Strategies
      </p>
    </div>

    <!-- Tab 3 -->
    <div style="width:200px; background:#009ddc; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#006b99; color:#fff; padding:5px; border-radius:20px; display:inline-block;">03</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Tax Planning<br>Income Tax Planning<br>Strategic Tax Reduction<br>Tax-efficient Investing<br>2025 New Tax Code Updates<br>Charitable Donations
      </p>
    </div>

    <!-- Tab 4 -->
    <div style="width:200px; background:#8cc63f; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#568c1f; color:#fff; padding:5px; border-radius:20px; display:inline-block;">04</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Estate Planning<br>Wealth Transfer<br>Philanthropy<br>Trusts & Wills<br>Succession Planning<br>Estate Administration
      </p>
    </div>

    <!-- Tab 5 -->
    <div style="width:200px; background:#009688; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#00665a; color:#fff; padding:5px; border-radius:20px; display:inline-block;">05</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Business Planning<br>Defined Contribution Plans<br>Employee Benefits<br>Business Risk Analysis<br>Business Valuation
      </p>
    </div>

    <!-- Tab 6 -->
    <div style="width:200px; background:#d81b60; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#8a0037; color:#fff; padding:5px; border-radius:20px; display:inline-block;">06</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Risk Management<br>Asset Protection<br>Insurance Coverage<br>Long-term Care<br>Disability Insurance<br>Business Risk Management
      </p>
    </div>

  </div>




  
  <!-- Title -->
  <h2 style="text-align:center; color:#fff; padding:20px; margin:0;">WEALTH MANAGEMENT</h2>

  <!-- Wire with Arrow Pointers -->
  <div style="width:100%; height:5px; background:#fff; position:relative; margin:20px 0;">
    <!-- Arrow pointers -->
    <div style="width:0; height:0; border-left:10px solid transparent; border-right:10px solid transparent; border-top:10px solid #fff; position:absolute; left:15%; top:-10px;"></div>
    <div style="width:0; height:0; border-left:10px solid transparent; border-right:10px solid transparent; border-top:10px solid #fff; position:absolute; left:32%; top:-10px;"></div>
    <div style="width:0; height:0; border-left:10px solid transparent; border-right:10px solid transparent; border-top:10px solid #fff; position:absolute; left:49%; top:-10px;"></div>
    <div style="width:0; height:0; border-left:10px solid transparent; border-right:10px solid transparent; border-top:10px solid #fff; position:absolute; left:66%; top:-10px;"></div>
    <div style="width:0; height:0; border-left:10px solid transparent; border-right:10px solid transparent; border-top:10px solid #fff; position:absolute; left:83%; top:-10px;"></div>
  </div>

  <!-- Container for Hanging Tabs -->
  <div style="display:flex; justify-content:center; align-items:flex-start; gap:20px; margin-top:-10px;">

    <!-- Tab 1 -->
    <div style="width:200px; background:#f4a21a; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#e67e00; color:#fff; padding:5px; border-radius:20px; display:inline-block;">01</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Financial Planning<br>Cash Flow & Budgeting<br>Risk & Debt Management<br>Retirement Planning<br>Goal Setting & Prioritization
      </p>
    </div>

    <!-- Tab 2 -->
    <div style="width:200px; background:#e94f37; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#b32719; color:#fff; padding:5px; border-radius:20px; display:inline-block;">02</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Investment Management<br>Global Diversification<br>Asset Allocation<br>Portfolio Monitoring<br>Rebalancing<br>Investment Strategies
      </p>
    </div>

    <!-- Tab 3 -->
    <div style="width:200px; background:#009ddc; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#006b99; color:#fff; padding:5px; border-radius:20px; display:inline-block;">03</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Tax Planning<br>Income Tax Planning<br>Strategic Tax Reduction<br>Tax-efficient Investing<br>2025 New Tax Code Updates<br>Charitable Donations
      </p>
    </div>

    <!-- Tab 4 -->
    <div style="width:200px; background:#8cc63f; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#568c1f; color:#fff; padding:5px; border-radius:20px; display:inline-block;">04</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Estate Planning<br>Wealth Transfer<br>Philanthropy<br>Trusts & Wills<br>Succession Planning<br>Estate Administration
      </p>
    </div>

    <!-- Tab 5 -->
    <div style="width:200px; background:#009688; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#00665a; color:#fff; padding:5px; border-radius:20px; display:inline-block;">05</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Business Planning<br>Defined Contribution Plans<br>Employee Benefits<br>Business Risk Analysis<br>Business Valuation
      </p>
    </div>

    <!-- Tab 6 -->
    <div style="width:200px; background:#d81b60; border-radius:0 0 50px 50px; padding:20px; text-align:center; position:relative;">
      <div style="width:2px; height:20px; background:#fff; position:absolute; top:-20px; left:50%; transform:translateX(-50%);"></div>
      <h3 style="margin:0; background:#8a0037; color:#fff; padding:5px; border-radius:20px; display:inline-block;">06</h3>
      <p style="margin:15px 0 0; font-size:14px; line-height:1.4;">
        Risk Management<br>Asset Protection<br>Insurance Coverage<br>Long-term Care<br>Disability Insurance<br>Business Risk Management
      </p>
    </div>

  </div>


  <!-- Title -->
  <h2 style="text-align:center; margin-bottom:30px; font-size:26px; letter-spacing:1px;">
    PRODUCT VS PROCESS AUDIT
  </h2>

  <!-- Top Labels -->
  <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:40px;">

    <!-- Product Audit -->
    <div style="background:#e0e6ed; color:#333; padding:12px 20px; border-radius:6px; font-weight:bold; font-size:14px;">
      Product Audit
    </div>

    <!-- Process Audit -->
    <div style="background:#e0e6ed; color:#333; padding:12px 20px; border-radius:6px; font-weight:bold; font-size:14px;">
      Process Audit
    </div>

  </div>

  <!-- Steps -->
  <div style="display:flex; flex-direction:column; gap:30px; max-width:1200px; margin:auto;">

    <!-- Row 1 -->
    <div style="display:flex; justify-content:space-between; align-items:center;">

      <!-- Left Box -->
      <div style="background:#d32f2f; padding:20px; border-radius:8px; width:40%; font-size:14px;">
        Company’s product (the item to audit quality system)
      </div>

      <!-- Middle Number -->
      <div style="background:#b71c1c; color:#fff; font-weight:bold; border-radius:50%; width:60px; height:60px; display:flex; align-items:center; justify-content:center; font-size:18px; margin:0 20px;">
        01
      </div>

      <!-- Right Box -->
      <div style="background:#d32f2f; padding:20px; border-radius:8px; width:40%; font-size:14px;">
        Specific processes, activities, or functions performed in an organization
      </div>

    </div>

    <!-- Row 2 -->
    <div style="display:flex; justify-content:space-between; align-items:center;">

      <!-- Left Box -->
      <div style="background:#fbc02d; color:#333; padding:20px; border-radius:8px; width:40%; font-size:14px;">
        Focuses on one more products or services and answers the “Does it work”
      </div>

      <!-- Middle Number -->
      <div style="background:#f57f17; color:#fff; font-weight:bold; border-radius:50%; width:60px; height:60px; display:flex; align-items:center; justify-content:center; font-size:18px; margin:0 20px;">
        02
      </div>

      <!-- Right Box -->
      <div style="background:#fbc02d; color:#333; padding:20px; border-radius:8px; width:40%; font-size:14px;">
        Compares the actual process activities documented/procedures of the process
      </div>

    </div>

    <!-- Row 3 -->
    <div style="display:flex; justify-content:space-between; align-items:center;">

      <!-- Left Box -->
      <div style="background:#388e3c; padding:20px; border-radius:8px; width:40%; font-size:14px;">
        For example, an auditing firm may examine whether the production department followed the production procedures defined in the work specification
      </div>

      <!-- Middle Number -->
      <div style="background:#1b5e20; color:#fff; font-weight:bold; border-radius:50%; width:60px; height:60px; display:flex; align-items:center; justify-content:center; font-size:18px; margin:0 20px;">
        03
      </div>

      <!-- Right Box -->
      <div style="background:#388e3c; padding:20px; border-radius:8px; width:40%; font-size:14px;">
        For example, the auditor may conduct an audit of the design process, manufacturing process, or inspection process
      </div>

    </div>

  </div>


  

  <!-- Footer -->
  <div style="text-align:right; margin-top:40px; font-size:12px; color:#ccc;">
    Source: zenpresentation.com
  </div>
<?php include('includes/footer.php'); ?>
