<?php include('includes/header.php'); ?>

<style>
/* ========== UTILITY LINES ========== */
.hr { height: 10px; border: 0; background-color: #469DFF; }
.hr2 { height: 10px; border: 0; background-color: #ff0000; }
.hr3 { height: 10px; border: 0; background-color: #000000; }
.hr4 { height: 10px; border: 0; background-color: #008000; }
.hr5 { height: 5px; border: 0; background-color: #FFFFFF; }
.hr6 { height: 10px; border: 0; background-color: #000066; }

/* ========== CAROUSEL ========== */
.carousel-header { 
  position: relative;
  margin-bottom: 0;
}

.carousel-header .carousel-item { 
  height: 500px; 
}

.carousel-header .carousel-item img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  object-position: center;
}

.carousel-caption { 
  background: rgba(0, 0, 0, 0.7); 
  padding: 25px; 
  border-radius: 10px;
  backdrop-filter: blur(5px);
}

.carousel-caption h5 {
  font-size: 28px;
  font-weight: bold;
  margin-bottom: 10px;
}

/* ========== NEWS TICKER ========== */
.news-ticker {
  display: flex;
  align-items: center;
  background-color: #001f5b;
  color: white;
  font-family: 'Segoe UI', sans-serif;
  font-weight: bold;
  font-size: 16px;
  padding: 12px 20px;
  gap: 15px;
}

.live-badge {
  background-color: #ff0000;
  color: white;
  padding: 4px 8px;
  font-size: 12px;
  border-radius: 4px;
  animation: pulse 2s infinite;
  font-weight: 700;
}

@keyframes pulse {
  0%, 100% { opacity: 1; }
  50% { opacity: 0.6; }
}

.news-ticker marquee { flex: 1; }
.news-ticker a { 
  color: white; 
  text-decoration: none; 
  transition: all 0.3s ease;
}
.news-ticker a:hover { 
  color: #ffd700;
  text-shadow: 0 0 10px rgba(255, 215, 0, 0.5);
}

/* ========== COMPANY SECTION ========== */
.company-section {
  display: flex;
  max-width: 1200px;
  margin: 50px auto;
  gap: 30px;
  padding: 0 20px;
  box-sizing: border-box;
  align-items: stretch;
}

.company-content {
  flex: 2;
  min-width: 300px;
  background: white;
  padding: 40px;
  border-radius: 12px;
  box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
}

.company-content h1 {
  font-size: 36px;
  color: #1a202c;
  font-weight: 800;
  margin-bottom: 25px;
  line-height: 1.2;
  border-bottom: 4px solid #667eea;
  padding-bottom: 15px;
}

.company-content p {
  font-size: 16px;
  line-height: 1.8;
  color: #2d3748;
  margin-bottom: 20px;
  text-align: justify;
}

.company-sidebar {
  flex: 1;
  min-width: 280px;
}

.profile-card {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
  transition: transform 0.3s ease;
}

.profile-card:hover {
  transform: translateY(-5px);
}

.profile-image-wrapper {
  width: 100%;
  height: 300px;
  overflow: hidden;
  background: #f5f5f5;
}

.profile-image-wrapper img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  object-position: center;
  transition: transform 0.3s ease;
}

.profile-card:hover .profile-image-wrapper img {
  transform: scale(1.05);
}

.profile-info {
  padding: 25px;
  background: rgba(255, 255, 255, 0.98);
  text-align: center;
}

.profile-info h3 {
  font-size: 24px;
  color: #2d3748;
  margin: 0 0 8px 0;
  font-weight: 700;
}

.profile-info p {
  font-size: 16px;
  color: #667eea;
  margin: 0;
  font-weight: 600;
  text-transform: uppercase;
  letter-spacing: 1px;
}

/* ========== SERVICES SECTION ========== */
.services-container {
  max-width: 1300px;
  margin: 60px auto;
  background: #fff;
  border: 1px solid #e2e8f0;
  border-radius: 16px;
  box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
  padding: 50px;
}

.section-title {
  text-align: center;
  font-size: 36px;
  font-weight: 800;
  color: #1a202c;
  margin-bottom: 40px;
  position: relative;
  padding-bottom: 15px;
}

.section-title::after {
  content: '';
  position: absolute;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  width: 80px;
  height: 4px;
  background: linear-gradient(90deg, #667eea, #764ba2);
  border-radius: 2px;
}

.services-layout {
  display: flex;
  flex-wrap: wrap;
  gap: 50px;
  justify-content: space-between;
}

.course-overview {
  flex: 1 1 350px;
  min-width: 300px;
}

.course-overview h3 {
  font-size: 26px;
  color: #2d3748;
  margin-bottom: 20px;
  font-weight: 700;
}

.course-overview p {
  line-height: 1.9;
  margin-bottom: 18px;
  color: #4a5568;
  font-size: 15px;
}

.course-list {
  flex: 1.5 1 350px;
  min-width: 300px;
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
  gap: 25px;
}

.course-item {
  display: flex;
  gap: 18px;
  padding: 20px;
  border: 1px solid #e2e8f0;
  border-radius: 10px;
  transition: all 0.3s ease;
  background: #fafafa;
}

.course-item:hover {
  transform: translateX(8px);
  box-shadow: 0 4px 15px rgba(102, 126, 234, 0.15);
  border-color: #667eea;
}

.course-icon {
  border: 2px solid #667eea;
  padding: 12px;
  font-size: 28px;
  border-radius: 10px;
  background: white;
  flex-shrink: 0;
  width: 56px;
  height: 56px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.course-info {
  flex: 1;
}

.course-info strong {
  display: block;
  margin-bottom: 6px;
  color: #2d3748;
  font-size: 17px;
  font-weight: 700;
}

.course-info span {
  font-size: 14px;
  color: #718096;
  line-height: 1.5;
}

/* ========== CARD GRID ========== */
.card-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
  gap: 25px;
  padding: 50px 30px;
  font-family: 'Georgia', serif;
}

.card-grid.bg-green { 
  background: linear-gradient(135deg, #2db828 0%, #25a01e 100%);
}

.card-grid.bg-beige { 
  background: linear-gradient(135deg, #dfcf92 0%, #d4c380 100%);
}

.card-grid.bg-blue { 
  background: linear-gradient(135deg, #a1c9d3 0%, #8fb9c5 100%);
}

.card {
  background-color: #fff;
  padding: 25px;
  box-shadow: 0 6px 20px rgba(0, 0, 0, 0.12);
  border-radius: 12px;
  transition: all 0.3s ease;
}

.card:hover {
  transform: translateY(-8px);
  box-shadow: 0 12px 30px rgba(0, 0, 0, 0.18);
}

.card h2 {
  font-size: 22px;
  color: #1a202c;
  margin: 0 0 18px;
  font-weight: 700;
}

.card img {
  width: 100%;
  height: auto;
  max-height: 250px;
  object-fit: contain;
  object-position: center;
  border-radius: 8px;
  margin: 18px 0;
  display: block;
  background: #f7fafc;
  padding: 15px;
  transition: transform 0.3s ease;
}

.card:hover img {
  transform: scale(1.05);
}

.card p {
  font-size: 15px;
  color: #4a5568;
  line-height: 1.7;
}

/* ========== RESPONSIVE DESIGN ========== */
@media (max-width: 968px) {
  .company-section {
    flex-direction: column;
  }

  .company-content h1 {
    font-size: 28px;
  }

  .profile-card {
    max-width: 400px;
    margin: 0 auto;
  }

  .services-layout {
    flex-direction: column;
  }

  .course-list {
    grid-template-columns: 1fr;
  }

  .carousel-header .carousel-item {
    height: 350px;
  }
}

@media (max-width: 768px) {
  .carousel-header .carousel-item {
    height: 300px;
  }

  .carousel-caption h5 {
    font-size: 20px;
  }

  .company-content {
    padding: 30px 25px;
  }

  .services-container {
    padding: 35px 25px;
  }

  .section-title {
    font-size: 28px;
  }

  .card-grid {
    padding: 35px 20px;
  }
}

@media (max-width: 480px) {
  .carousel-header .carousel-item {
    height: 250px;
  }

  .company-content h1 {
    font-size: 24px;
  }

  .profile-image-wrapper {
    height: 250px;
  }

  .section-title {
    font-size: 24px;
  }

  .card img {
    max-height: 200px;
  }
}
</style>

<!-- ========== CAROUSEL ========== -->
<div class="carousel-header">
  <div id="carouselId" class="carousel slide" data-bs-ride="carousel" data-bs-interval="4000">
    <ol class="carousel-indicators">
      <li data-bs-target="#carouselId" data-bs-slide-to="0" class="active"></li>
      <li data-bs-target="#carouselId" data-bs-slide-to="1"></li>
      <li data-bs-target="#carouselId" data-bs-slide-to="2"></li>
    </ol>

    <div class="carousel-inner" role="listbox">
      <div class="carousel-item active">
        <img src="img/sider/coro1.jpg" class="d-block w-100 img-fluid" alt="Slide 1">
        <div class="carousel-caption d-none d-md-block">
          <h5>Welcome to Twin Beam Enterprises</h5>
          <p>Your trusted partner in innovative technology solutions.</p>
        </div>
      </div>
      <div class="carousel-item">
        <img src="img/sider/coro2.jpg" class="d-block w-100 img-fluid" alt="Slide 2">
        <div class="carousel-caption d-none d-md-block">
          <h5>Quality Products & Services</h5>
          <p>From asset tagging to networking solutions.</p>
        </div>
      </div>
      <div class="carousel-item">
        <img src="img/sider/coro4.jpg" class="d-block w-100 img-fluid" alt="Slide 3">
        <div class="carousel-caption d-none d-md-block">
          <h5>Experience & Innovation</h5>
          <p>Building partnerships for sustainable growth.</p>
        </div>
      </div>
    </div>

    <button class="carousel-control-prev" type="button" data-bs-target="#carouselId" data-bs-slide="prev">
      <span class="carousel-control-prev-icon btn bg-primary" aria-hidden="true"></span>
      <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#carouselId" data-bs-slide="next">
      <span class="carousel-control-next-icon btn bg-primary" aria-hidden="true"></span>
      <span class="visually-hidden">Next</span>
    </button>
  </div>
</div>

<!-- ========== NEWS TICKER ========== -->
<div class="news-ticker">
  <div class="live-badge">LIVE</div>
  <marquee behavior="scroll" direction="left" scrollamount="6" id="news-marquee">Loading headlines...</marquee>
</div>

<script>
const headlines = [
  { text: "🔵 Faith Based Hospitals", link: "https://defmis.org/Faithbased_hospitals.php" },
  { text: "🚧 All Accredited Hospital", link: "https://defmis.org/img/Documents/DEFMIS_ACCREDITED_HOSPITALS_AS_AT_30_MAY_2025.pdf" },
  { text: "🏛️ Defmis Guidelines", link: "https://defmis.org/Guidelines.php" },
  { text: "⚽ Contact Us", link: "https://defmis.org/contact_us.php" },
  { text: "🌦️ Defmis Portal", link: "https://portal.defmis.org/login" },
  { text: "🌦️ Nyayo House", link: "https://share.google/67pOpcaLKU4JXY3bW" }
];

document.getElementById('news-marquee').innerHTML = headlines.map(item =>
  `<a href="${item.link}" target="_blank">${item.text}</a>`
).join('&nbsp;&nbsp;|&nbsp;&nbsp;');
</script>

<div class="hr"></div>

<!-- ========== COMPANY SECTION ========== -->
<style>

.ico-container {
  display: flex;
  max-width: 1200px;
  margin: 40px auto;
  border: 1px solid #e0e0e0;
  background: linear-gradient(135deg, #cbd0e4f 0%, #dfd8e6ff 100%);
  box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
  border-radius: 16px;
  overflow: hidden;
}

.ico-article {
  flex: 1;
  padding: 40px;
  background: linear-gradient(135deg, rgba(203, 208, 228, 1) 0%, rgba(223, 216, 230, 1) 100%);
  line-height: 1.8;
  backdrop-filter: blur(10px);
}

.ico-article h1 {
  font-size: 32px;
  margin: 0 0 15px 0;
  color: #1a202c;
  font-weight: 800;
  letter-spacing: -0.5px;
  line-height: 1.2;
}

.ico-article .byline {
  font-size: 13px;
  color: #718096;
  margin-bottom: 25px;
  text-transform: uppercase;
  letter-spacing: 1px;
  font-weight: 600;
}

.ico-article p {
  margin-bottom: 20px;
  text-align: justify;
  color: #2d3748;
  font-size: 15px;
  line-height: 1.7;
}

.ico-details {
  flex: 0 0 400px;
  padding: 40px 30px;
  background: linear-gradient(135deg, #cbd0e4ff 0%, #dfd8e6ff 100%);
  display: flex;
  flex-direction: column;
  gap: 25px;
}

.sidebar-image-box {
  background: rgba(255, 255, 255, 0.95);
  padding: 20px;
  border-radius: 12px;
  text-align: center;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
  backdrop-filter: blur(10px);
}

.sidebar-image-box img {
  width: 100%;
  height: 400px;
  object-fit: cover;
  object-position: center;
  border-radius: 8px;
  margin-bottom: 15px;
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
}

.sidebar-image-box h3 {
  font-size: 18px;
  color: #2d3748;
  margin: 0 0 12px 0;
  font-weight: 700;
}

.sidebar-image-box p {
  font-size: 14px;
  color: #4a5568;
  line-height: 1.6;
  margin: 0;
  text-align: center;
}

/* Responsive Design */
@media (max-width: 968px) {
  .ico-container {
    flex-direction: column;
  }

  .ico-details {
    flex: 1;
  }

  .ico-article h1 {
    font-size: 26px;
  }
}

@media (max-width: 480px) {
  .ico-article,
  .ico-details {
    padding: 25px 20px;
  }

  .ico-article h1 {
    font-size: 22px;
  }

  .sidebar-image-box img {
    height: 220px;
  }
}
</style>

<!-- ========== ICO SECTION ========== -->
<div class="ico-container">
  <div class="ico-article">
    <h1>Twin Beam Enterprises: Your Trusted Technology Partner</h1>
    <p class="byline">About Our Company</p>
    <p>Twin Beam Enterprises is a registered company in Kenya that specializes in the provision of cost-effective products and services ranging from asset tagging, computers and accessories, Networking, printing/branding services, supply of stationeries among others.</p>
    <p>We focus on delivering high-impact solutions that incorporate customized functionality specific to the client's requirements. The combination of thorough process, comprehensive experience and expansive creative vision enables us to provide services and products that are innovative, usable and reliable.</p>
    <p>Twin Beam Enterprises was established in response to the growing market demand for high quality innovative solutions at affordable prices. Our commitment to refining the development has allowed us to introduce a wide range of products as well as customized solutions that enable businesses to simplify their operations.</p>
    <p>With business experience and an ongoing relationship with well established companies, our staffs have worked with business leading companies to acquire an in depth understanding of the latest technologies and processes.</p>
  </div>

  <div class="ico-details">
    <div class="sidebar-image-box">
      <img src="img/sider/filler.jpg" alt="Twin Beam Enterprises">
      <h3>Innovation & Growth</h3>
      <p>Transforming businesses with cutting-edge technology solutions tailored to meet your specific needs.</p>
    </div>  
  </div>
</div>

<hr style="border: 3px solid blue; margin: 40px 0;">

<!-- ========== SERVICES SECTION ========== -->
<!-- ========== PRODUCTS SECTION (MODERN CARDS) ========== -->
<div style="
    background: linear-gradient(135deg, rgba(232, 236, 228, 1) 0%, rgba(244, 241, 248, 1) 100%);
    padding:60px 20px;
    border-radius:12px;
    max-width:1300px;
    margin:40px auto;
    box-sizing:border-box;
">

    <!-- Section Header -->    
<h3 style="font-size:28px; font-weight:bold; margin-bottom:10px; color:#222; text-align:center;">
  PRODUCTS
</h3>
  
    <!-- Products Grid -->
    <div style="display:flex; flex-wrap:wrap; gap:30px; justify-content:space-between;">

        <!-- Asset Tags -->
        <div style="
            flex:0 0 48%;
            background:#fff;
            border-radius:12px;
            padding:20px;
            box-shadow:0 4px 10px rgba(0,0,0,0.1);
            display:flex;
            gap:15px;
            align-items:flex-start;
        ">
            <div style="font-size:30px; color:#f39c12;">🏷️</div>
            <div>
                <h3 style="margin:0 0 10px; font-size:18px; font-weight:bold; color:#222;">Asset Tags</h3>
                <p style="margin:0; color:#555; font-size:14px; line-height:1.6;">
                    An asset is a thing of value i.e., property owned by an individual or a company. Twin Beam provides long lasting acetone activated aluminum asset tags with a QR code or barcode depending on preference. Tags contain company Name, logo, and unique asset number. Data is read via scanners connected to asset verification software.
                </p>
            </div>
        </div>

        <!-- Barcode Scanners -->
        <div style="
            flex:0 0 48%;
            background:#fff;
            border-radius:12px;
            padding:20px;
            box-shadow:0 4px 10px rgba(0,0,0,0.1);
            display:flex;
            gap:15px;
            align-items:flex-start;
        ">
            <div style="font-size:30px; color:#f39c12;">📡</div>
            <div>
                <h3 style="margin:0 0 10px; font-size:18px; font-weight:bold; color:#222;">Barcode Scanners</h3>
                <p style="margin:0; color:#555; font-size:14px; line-height:1.6;">
                    We supply hand-held barcode scanners for accurate asset data capture, especially during stock-taking. Scanners transmit information to the asset tagging software in seconds, saving time.
                </p>
            </div>
        </div>

        <!-- Computers & Accessories -->
        <div style="
            flex:0 0 48%;
            background:#fff;
            border-radius:12px;
            padding:20px;
            box-shadow:0 4px 10px rgba(0,0,0,0.1);
            display:flex;
            gap:15px;
            align-items:flex-start;
        ">
            <div style="font-size:30px; color:#f39c12;">💻</div>
            <div>
                <h3 style="margin:0 0 10px; font-size:18px; font-weight:bold; color:#222;">Computers & Accessories</h3>
                <p style="margin:0; color:#555; font-size:14px; line-height:1.6;">
                    We supply latest computers and laptops (HP, Dell, Toshiba, Compaq) plus input/output devices: keyboards, mice, monitors, printers, USB drives, external hard drives, and USB hubs.
                </p>
            </div>
        </div>

        <!-- Networking Products -->
        <div style="
            flex:0 0 48%;
            background:#fff;
            border-radius:12px;
            padding:20px;
            box-shadow:0 4px 10px rgba(0,0,0,0.1);
            display:flex;
            gap:15px;
            align-items:flex-start;
        ">
            <div style="font-size:30px; color:#f39c12;">🌐</div>
            <div>
                <h3 style="margin:0 0 10px; font-size:18px; font-weight:bold; color:#222;">Networking Products</h3>
                <p style="margin:0; color:#555; font-size:14px; line-height:1.6;">
                    We supply networking products including Ethernet cables (CAT5 & 6), switches, routers, RJ45 connectors, access points, and hubs.
                </p>
            </div>
        </div>

        <!-- Printing & Branding -->
        <div style="
            flex:0 0 48%;
            background:#fff;
            border-radius:12px;
            padding:20px;
            box-shadow:0 4px 10px rgba(0,0,0,0.1);
            display:flex;
            gap:15px;
            align-items:flex-start;
        ">
            <div style="font-size:30px; color:#f39c12;">🖨️</div>
            <div>
                <h3 style="margin:0 0 10px; font-size:18px; font-weight:bold; color:#222;">Printing & Branding</h3>
                <p style="margin:0; color:#555; font-size:14px; line-height:1.6;">
                    We supply printing materials and promotional products like t-shirts, hoodies, and caps for branding purposes.
                </p>
            </div>
        </div>

        <!-- Office Stationaries -->
        <div style="
            flex:0 0 48%;
            background:#fff;
            border-radius:12px;
            padding:20px;
            box-shadow:0 4px 10px rgba(0,0,0,0.1);
            display:flex;
            gap:15px;
            align-items:flex-start;
        ">
            <div style="font-size:30px; color:#f39c12;">📎</div>
            <div>
                <h3 style="margin:0 0 10px; font-size:18px; font-weight:bold; color:#222;">Office Stationaries</h3>
                <p style="margin:0; color:#555; font-size:14px; line-height:1.6;">
                    We supply various office stationaries including printing papers, box files, envelopes, pens, and other essential office supplies.
                </p>
            </div>
        </div>

    </div>
</div>

</div>

<!-- ========== CARD SECTIONS ========== -->
<div class="card-grid bg-blue">
  <div class="card">
    <h6>Bahati Hospital</h6>
    <img src="img/icon/tag3.jpeg" alt="Bahati Hospital">  
     <a href="img/documents/Bahati.pdf" download class="pdf-download">
     Recomendation
    </a>  
  </div>

  <div class="card">
    <h6>Kiambaa Dairy Farmers</h6>
    <img src="img/icon/tag4.jpeg" alt="Kiambaa Dairy Farmers">   
     <a href="path/to/bahati-hospital.pdf" download class="pdf-download">
     Recomendation
    </a>  
  </div>

  <div class="card">
    <h6>Ammar SACCO society Limited</h6>
    <img src="img/icon/tag2.jpeg" alt="Customer Support"> 
     <a href="path/to/bahati-hospital.pdf" download class="pdf-download">
     Recomendation
    </a>    
  </div>

  <div class="card">
    <h6>Bubble Restaurant</h6>
    <img src="img/icon/tag1.jpeg" alt="Competitive Pricing">   
     <a href="path/to/bahati-hospital.pdf" download class="pdf-download">
     Recomendation
    </a>  
  </div>
</div>

<div class="card-grid bg-beige">
  <div class="card">
   <h6>Juja Road Hospital</h6>
    <img src="img/icon/tag8.jpeg" alt="Professional Team">   
     <a href="path/to/bahati-hospital.pdf" download class="pdf-download">
     Recomendation
    </a>  
  </div>

  <div class="card">
     <h6>Kongoni Camp</h6>
    <img src="img/icon/tag7.jpeg" alt="Reliable Service">  
     <a href="path/to/bahati-hospital.pdf" download class="pdf-download">
     Recomendation
    </a>    
  </div>

  <div class="card">
     <h6>Wama Nursing Home</h6>
    <img src="img/icon/tag6.jpeg" alt="Modern Equipment">   
     <a href="img/documents/Wama.pdf" download class="pdf-download">
     Recomendation
    </a>   
  </div>

  <div class="card">
     <h6>Nairobi Centre for International Arbitration</h6>
    <img src="img/icon/tag5.jpeg" alt="Strategic Partnerships">  
     <a href="img/documents/ncia.pdf" download class="pdf-download">
     Recomendation
    </a>   
  </div>
</div>
  
</div>

<?php include('includes/footer.php'); ?>