<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>TWINBEAM</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    :root {
      --primary-color: #001b60;
      --accent-red: rgba(238, 245, 239, 1);
      --text-light: #ffffff;
    }
    body {
      margin: 0;
      font-family: Arial, sans-serif;
    }
    .top-header {
      background: #0a8f10ff;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 10px 20px;
    }
    .top-header .logo {
      height: 60px;
    }
    .top-header .title {
      flex: 1;
      margin-left: 20px;
      text-align: center;
    }
    .top-header .title h1 {
      margin: 0;
      font-size: 50px;
      color: #ecf3ea;
    }
    .top-header .title p {
      margin: 0;
      color: white;
    }
    .flag {
      position: relative;
      width: 50px;
      height: 50px;
      display: flex;
      flex-direction: column;
      border: 1px solid #000;
    }
    .flag div {
      flex: 1;
    }
    .black-stripe { background-color: black; }
    .red-stripe {
      background-color: red;
      border-top: 2px solid white;
      border-bottom: 2px solid white;
    }
    .green-stripe { background-color: green; }
    .shield {
      position: absolute;
      top: 50%;
      left: 50%;
      width: 12px;
      height: 28px;
      background-color: white;
      border: 2px solid black;
      border-radius: 50%/60%;
      transform: translate(-50%, -50%);
      z-index: 2;
    }
    .navbar {
      background: var(--primary-color);
    }
    .navbar-nav .nav-link {
      color: white;
      font-weight: 500;
    }
    .navbar-nav .nav-link:hover,
    .navbar-nav .nav-link.active {
      color: var(--accent-red);
    }
    .navbar-brand {
      color: white;
      font-weight: bold;
    }
    .logout-link {
      color: white;
      margin-left: 15px;
    }
    .logout-link:hover {
      color: #ffd700;
    }

    /* Submenu styles */
    .dropdown-submenu {
      position: relative;
    }
    .dropdown-submenu > .dropdown-menu {
      top: 0;
      left: 100%;
      margin-top: -1px;
      display: none;
    }
    .dropdown-submenu:hover > .dropdown-menu {
      display: block;
    }
  </style>
</head>
<body>

<!-- Top Header -->
<div class="top-header">
  <img src="img/icon/Untitled%20design%20(1).png" alt="Logo" class="logo">
  <div class="title">
    <h1>TWIN BEAM ENTERPRISES</h1>
    <p>Your Trusted Technology Partner
</p>
  </div>
  <div class="flag">
    <div class="black-stripe"></div>
    <div class="red-stripe"></div>
    <div class="green-stripe"></div>
    <div class="shield"></div>
  </div>
</div>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark">
  <div class="container">
    <a class="navbar-brand" href="index.php">TWINBEAM</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain"
            aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarMain">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link <?= $current_page == 'index.php' ? 'active' : '' ?>" href="index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link <?= $current_page == 'about.php' ? '' : '' ?>" href="about.php">About Us</a></li>                              

        <!-- Hospitals Dropdown -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle <?= $current_page == 'media.php' ? 'active' : '' ?>" href="#" role="button" data-bs-toggle="dropdown">Our Services</a>
          <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="services.php">Our Services</a></li>
            <li><a class="dropdown-item" href="ourinfo.php">Why Choose Us </a></li>            
          </ul>
        </li>            

        <!-- Other Pages -->
        <li class="nav-item"><a class="nav-link <?= $current_page == 'downloads.php' ? 'active' : '' ?>" href="downloads.php">Downloads</a></li>
        <li class="nav-item"><a class="nav-link <?= $current_page == 'contact_us.php' ? 'active' : '' ?>" href="contact_us.php">Contact Us</a></li>
        <li class="nav-item"><a class="nav-link <?= $current_page == 'faqs.php' ? 'active' : '' ?>" href="faqs.php">FAQs</a></li>
      
      </ul>
    </div>
  </div>
</nav>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
  // Toggle dark mode
  const toggleSwitch = document.getElementById('darkModeSwitch');
  if (toggleSwitch) {
    toggleSwitch.addEventListener('change', function () {
      document.body.classList.toggle('dark-mode', this.checked);
    });
  }

  // Enable submenu toggle for mobile
  document.querySelectorAll('.dropdown-submenu .dropdown-toggle').forEach(function (element) {
    element.addEventListener('click', function (e) {
      e.preventDefault();
      const nextMenu = this.nextElementSibling;
      if (nextMenu && nextMenu.classList.contains('dropdown-menu')) {
        nextMenu.classList.toggle('show');
      }
    });
  });

  // Close submenus when main menu closes
  document.querySelectorAll('.dropdown').forEach(function (dropdown) {
    dropdown.addEventListener('hidden.bs.dropdown', function () {
      this.querySelectorAll('.dropdown-menu.show').forEach(function (subMenu) {
        subMenu.classList.remove('show');
      });
    });
  });
</script>
</body>
</html>
