<?php include('includes/header.php'); ?>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f8f9fa;
    }
    .contact-wrapper {
      background: #fff;
      border-radius: 12px;
      overflow: hidden;
      margin: 50px auto;
      max-width: 1100px;
      box-shadow: 0 0 20px rgba(0, 0, 0, 0.05);
    }
    .contact-header {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 40px;
      text-align: center;
    }
    .contact-header h2 {
      font-size: 32px;
      font-weight: 600;
      margin-bottom: 10px;
    }
    .contact-header p {
      font-size: 16px;
      margin: 0;
    }
    .info-item {
      margin-bottom: 20px;
    }
    .info-item i {
      color: #0d6efd;
      margin-right: 10px;
    }
    .department {
      margin-bottom: 25px;
      background: #f8f9fa;
      padding: 20px;
      border-left: 4px solid #0d6efd;
      border-radius: 8px;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .department:hover {
      transform: translateY(-5px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    .department h5 {
      color: #0d6efd;
      font-weight: 600;
      margin-bottom: 15px;
    }
    .department p {
      margin: 5px 0;
      font-size: 15px;
    }
    .map-container {
      padding: 30px;
      width: 100%;
    }
    iframe {
      width: 100%;
      height: 400px;
      border: 0;
      border-radius: 12px;
    }
    @media (max-width: 768px) {
      .contact-body {
        flex-direction: column;
      }
    }
  </style>
</head>
<body>

<!-- Contact Header -->
<div class="contact-wrapper">
  <div class="contact-header">
    <h2><i class="fas fa-phone-alt me-3"></i>Contact TWINBEAM</h2>
    <p>Professional Asset Tagging & IT Solutions</p>
    <p class="mt-2">Our team is ready to assist you with customized solutions tailored to your organization's needs</p>
  </div>

  <!-- Contact Information Cards -->
  <div class="container my-5">
    <div class="row g-4">

      <!-- Main Office -->
      <div class="col-md-6 col-lg-4">
        <div class="department">
          <h5><i class="fas fa-building me-2"></i>Main Office</h5>
          <p><i class="fas fa-map-marker-alt me-2 text-danger"></i>Nairobi, Kenya</p>
          <p><i class="fas fa-envelope-open me-2 text-info"></i>P.O Box 21710-00100, Nairobi</p>
          <p><i class="fas fa-phone-alt me-2 text-success"></i>+254 721 586 198</p>
          <p><i class="fas fa-phone-alt me-2 text-success"></i>+254 746 630 003</p>
          <p><i class="fas fa-phone-alt me-2 text-success"></i>+254 735 055 857</p>
          <p>
            <i class="fas fa-envelope me-2 text-primary"></i><a href="mailto:twinbeamenterprises@gmail.com">twinbeamenterprises@gmail.com</a>
          </p>
        </div>
      </div>   

      <!-- Sales Department -->
      <div class="col-md-6 col-lg-4">
        <div class="department" style="border-left-color: #28a745;">
          <h5 style="color: #28a745;"><i class="fas fa-tag me-2"></i>Sales & Quotations</h5>
          <p><i class="fas fa-phone-alt me-2 text-success"></i>+254 721 586 198</p>
          <p><i class="fas fa-envelope me-2 text-primary"></i><a href="mailto:twinbeamenterprises@gmail.com">twinbeamenterprises@gmail.com</a></p>
          <p><i class="fas fa-clock me-2 text-warning"></i>Monday - Friday: 8:00 AM - 5:00 PM</p>
          <p class="mt-3 text-muted"><small><i class="fas fa-info-circle me-2"></i>Request quotes for asset tagging, engraving, and IT equipment</small></p>
        </div>
      </div>

      <!-- Social Media & Support -->
      <div class="col-md-6 col-lg-4">
        <div class="department" style="border-left-color: #1877f2;">
          <h5 style="color: #1877f2;"><i class="fas fa-share-alt me-2"></i>Follow Us</h5>
          <p><i class="fab fa-facebook fa-lg me-2 text-primary"></i><a href="https://facebook.com/twinbeam" target="_blank">Facebook</a></p>
          <p><i class="fab fa-youtube fa-lg me-2 text-danger"></i><a href="https://youtube.com/twinbeam" target="_blank">YouTube</a></p>
          <p class="mt-3"><i class="fas fa-clock me-2 text-warning"></i>Business Hours: Mon-Fri, 8AM-5PM</p>
          <p class="text-muted"><small><i class="fas fa-info-circle me-2"></i>Stay updated with our latest projects and services</small></p>
        </div>
      </div>

    </div>
 <div class="mt-4">
            <a href="contact.php" class="btn btn-primary btn-lg px-5">Contact Us Now</a>
        </div>
    <!-- Service Highlights -->
    <div class="row mt-5">
      <div class="col-12">
        <h3 class="text-center mb-4">Our Services</h3>
      </div>
      
      <div class="col-md-6 col-lg-3 mb-3">
        <div class="text-center p-3 bg-light rounded shadow-sm h-100">
          <i class="fas fa-tags fa-3x text-primary mb-3"></i>
          <h6 class="fw-bold">Asset Tagging</h6>
          <p class="small text-muted mb-0">Barcode, QR code & RFID solutions</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-3 mb-3">
        <div class="text-center p-3 bg-light rounded shadow-sm h-100">
          <i class="fas fa-stamp fa-3x text-primary mb-3"></i>
          <h6 class="fw-bold">Asset Engraving</h6>
          <p class="small text-muted mb-0">Permanent laser & mechanical engraving</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-3 mb-3">
        <div class="text-center p-3 bg-light rounded shadow-sm h-100">
          <i class="fas fa-laptop fa-3x text-primary mb-3"></i>
          <h6 class="fw-bold">IT Equipment</h6>
          <p class="small text-muted mb-0">Computers, monitors & accessories</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-3 mb-3">
        <div class="text-center p-3 bg-light rounded shadow-sm h-100">
          <i class="fas fa-network-wired fa-3x text-primary mb-3"></i>
          <h6 class="fw-bold">Networking</h6>
          <p class="small text-muted mb-0">Complete network infrastructure setup</p>
        </div>
      </div>
    </div>

    <!-- Industries We Serve -->
    <div class="row mt-5">
      <div class="col-12">
        <h3 class="text-center mb-4">Industries We Serve</h3>
      </div>
      <div class="col-12">
        <div class="p-4 bg-light rounded text-center">
          <div class="row">
            <div class="col-md-2 col-4 mb-3">
              <i class="fas fa-hospital fa-2x text-primary mb-2 d-block"></i>
              <small class="fw-bold">Healthcare</small>
            </div>
            <div class="col-md-2 col-4 mb-3">
              <i class="fas fa-graduation-cap fa-2x text-primary mb-2 d-block"></i>
              <small class="fw-bold">Education</small>
            </div>
            <div class="col-md-2 col-4 mb-3">
              <i class="fas fa-landmark fa-2x text-primary mb-2 d-block"></i>
              <small class="fw-bold">Government</small>
            </div>
            <div class="col-md-2 col-4 mb-3">
              <i class="fas fa-building fa-2x text-primary mb-2 d-block"></i>
              <small class="fw-bold">Corporate</small>
            </div>
            <div class="col-md-2 col-4 mb-3">
              <i class="fas fa-industry fa-2x text-primary mb-2 d-block"></i>
              <small class="fw-bold">Manufacturing</small>
            </div>
            <div class="col-md-2 col-4 mb-3">
              <i class="fas fa-hands-helping fa-2x text-primary mb-2 d-block"></i>
              <small class="fw-bold">NGOs</small>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Why Choose TWINBEAM -->
    <div class="row mt-5">
      <div class="col-12">
        <div class="p-4 rounded text-white text-center" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
          <h3 class="mb-4">Why Choose TWINBEAM?</h3>
          <div class="row">
            <div class="col-md-3 col-6 mb-3">
              <i class="fas fa-shield-alt fa-3x mb-2 d-block"></i>
              <h6>Trusted Provider</h6>
              <small>Extensive industry experience</small>
            </div>
            <div class="col-md-3 col-6 mb-3">
              <i class="fas fa-award fa-3x mb-2 d-block"></i>
              <h6>Quality Assurance</h6>
              <small>Industry best practices</small>
            </div>
            <div class="col-md-3 col-6 mb-3">
              <i class="fas fa-users fa-3x mb-2 d-block"></i>
              <h6>Expert Team</h6>
              <small>Skilled professionals</small>
            </div>
            <div class="col-md-3 col-6 mb-3">
              <i class="fas fa-headset fa-3x mb-2 d-block"></i>
              <h6>Full Support</h6>
              <small>After-sales service</small>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Getting Started -->
    <div class="row mt-5">
      <div class="col-12">
        <h3 class="text-center mb-4">How to Get Started</h3>
      </div>
      <div class="col-md-3 col-6 text-center mb-3">
        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
          <h4 class="mb-0">1</h4>
        </div>
        <h6>Contact Us</h6>
        <p class="small text-muted">Free consultation</p>
      </div>
      <div class="col-md-3 col-6 text-center mb-3">
        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
          <h4 class="mb-0">2</h4>
        </div>
        <h6>Assessment</h6>
        <p class="small text-muted">Environment evaluation</p>
      </div>
      <div class="col-md-3 col-6 text-center mb-3">
        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
          <h4 class="mb-0">3</h4>
        </div>
        <h6>Recommendation</h6>
        <p class="small text-muted">Best solution</p>
      </div>
      <div class="col-md-3 col-6 text-center mb-3">
        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
          <h4 class="mb-0">4</h4>
        </div>
        <h6>Implementation</h6>
        <p class="small text-muted">On-site execution</p>
      </div>
    </div>

  </div> <!-- container -->

  <!-- Google Map -->
  <div class="map-container">
    <h3 class="text-center mb-4">Find Us</h3>
    <iframe 
      src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d127642.39515796178!2d36.70730744663085!3d-1.3028618999999998!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x182f10d22c2e3c1d%3A0x4e3b1e8f5c3f5c3f!2sNairobi%2C%20Kenya!5e0!3m2!1sen!2ske!4v1234567890123!5m2!1sen!2ske" 
      width="100%" height="450" style="border:0;" 
      allowfullscreen="" 
      loading="lazy" 
      referrerpolicy="no-referrer-when-downgrade">
    </iframe>
  </div>

</div> <!-- contact-wrapper -->

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<?php include('includes/footer.php'); ?>