<?php
// Database configuration
$host = 'localhost';
$dbname = 'twinbeam';
$username = 'root';
$password = '';

// Create connection
$conn = new mysqli($host, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$message = '';
$messageType = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize input data
    $name = mysqli_real_escape_string($conn, trim($_POST['name']));
    $email = mysqli_real_escape_string($conn, trim($_POST['email']));
    $subject = mysqli_real_escape_string($conn, trim($_POST['subject']));
    $user_message = mysqli_real_escape_string($conn, trim($_POST['message']));
    
    // Validate inputs
    if (empty($name) || empty($email) || empty($subject) || empty($user_message)) {
        $message = "All fields are required!";
        $messageType = "danger";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Invalid email format!";
        $messageType = "danger";
    } else {
        // Insert into database
        $sql = "INSERT INTO contacts (name, email, subject, message, created_at) VALUES (?, ?, ?, ?, NOW())";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssss", $name, $email, $subject, $user_message);
        
        if ($stmt->execute()) {
            $message = "Thank you! Your message has been sent successfully. We will get back to you soon.";
            $messageType = "success";
            
            // Optional: Send email notification
            $to = "info@twinbeam.co.ke"; // Change to your email
            $email_subject = "New Contact Form Submission: " . $subject;
            $email_body = "Name: $name\nEmail: $email\nSubject: $subject\n\nMessage:\n$user_message";
            $headers = "From: noreply@twinbeam.co.ke\r\nReply-To: $email";
            
            @mail($to, $email_subject, $email_body, $headers);
        } else {
            $message = "Error: " . $stmt->error;
            $messageType = "danger";
        }
        
        $stmt->close();
    }
}

$conn->close();
?>

<?php include('includes/header.php'); ?>

<!-- Contact Form Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="text-center mb-5">
                    <h5 class="section-title px-3">Contact Us</h5>
                    <h1 class="mb-3">Get In Touch</h1>
                    <p class="text-muted">Have questions? We'd love to hear from you. Send us a message and we'll respond as soon as possible.</p>
                </div>

                <?php if (!empty($message)): ?>
                    <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show" role="alert">
                        <i class="fas fa-<?php echo $messageType === 'success' ? 'check-circle' : 'exclamation-circle'; ?> me-2"></i>
                        <?php echo $message; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <div class="card border-0 shadow">
                    <div class="card-body p-5">
                        <form method="POST" action="">
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label">Your Name <span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" placeholder="John Doe" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Your Email <span class="text-danger">*</span></label>
                                    <input type="email" name="email" class="form-control" placeholder="john@example.com" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Subject <span class="text-danger">*</span></label>
                                    <input type="text" name="subject" class="form-control" placeholder="How can we help you?" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Message <span class="text-danger">*</span></label>
                                    <textarea name="message" class="form-control" rows="6" placeholder="Tell us more about your inquiry..." required></textarea>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary w-100 py-3">
                                        <i class="fas fa-paper-plane me-2"></i>Send Message
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Info Section -->
        <div class="row mt-5">
            <div class="col-md-4 mb-4">
                <div class="card text-center h-100 border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                            <i class="fas fa-phone fa-2x"></i>
                        </div>
                        <h5>Call Us</h5>
                        <p class="text-muted mb-0">+254 700 123 456<br>+254 700 123 457</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card text-center h-100 border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                            <i class="fas fa-envelope fa-2x"></i>
                        </div>
                        <h5>Email Us</h5>
                        <p class="text-muted mb-0">info@twinbeam.co.ke<br>support@twinbeam.co.ke</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card text-center h-100 border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                            <i class="fas fa-map-marker-alt fa-2x"></i>
                        </div>
                        <h5>Visit Us</h5>
                        <p class="text-muted mb-0">Nairobi, Kenya<br>P.O Box [Your Box Number]</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.section-title {
  font-size: 1.2rem;
  font-weight: 600;
  color: #007bff;
  text-transform: uppercase;
  letter-spacing: 2px;
}

.form-label {
    font-weight: 500;
    color: #333;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
}
</style>


<?php include('includes/footer.php'); ?>