<?php include('includes/header.php'); ?>
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">



<style>
.hero-section {
  position: relative;
  height: 300px;
  background: url('img/sider/Meshack_slide.jpg') center center/cover no-repeat;
}
.hero-section .overlay {
  position: absolute;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.6);
}
.hero-section .breadcrumb {
  background: transparent;
  margin-top: 15px;
}
.hero-section .breadcrumb-item + .breadcrumb-item::before {
  color: #ffffff;
}
.section-hr {
  border: 1px solid #fff;
  opacity: 1;
  width: 100px;
  margin: 20px auto;
}
.fade-in {
  opacity: 0;
  animation: fadeIn 1.2s ease forwards;
}
@keyframes fadeIn {
  to {
    opacity: 1;
  }
}
</style>

<!-- HERO SECTION -->
<section class="hero-section text-center text-white d-flex align-items-center justify-content-center">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-5 fw-bold">Welcome to Our Church</h1>
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-center">
        <li class="breadcrumb-item"><a href="index.php" class="text-white text-decoration-underline">Home</a></li>
        <li class="breadcrumb-item active text-white" aria-current="page">Church Landing</li>
      </ol>
    </nav>
  </div>
</section>

<style>
  .btn-print {
    background-color: #13357B;
    color: #fff;
    font-weight: 500;
    border-radius: 5px;
    padding: 6px 12px;
    font-size: 0.85rem;
    line-height: 1.2;
  }

  .btn-print:hover {
    background-color: #0f2a61;
  }

  .filter-controls {
    text-align: center;
    margin-bottom: 20px;
  }

  .filter-controls input,
  .filter-controls select,
  .filter-controls button {
    margin: 5px;
    padding: 8px 12px;
    font-size: 14px;
  }

  .sermon-card {
    transition: all 0.4s ease-in-out;
    opacity: 1;
    transform: scale(1);
  }

  .sermon-card.hide {
    opacity: 0;
    transform: scale(0.98);
    pointer-events: none;
    height: 0;
    margin: 0 !important;
    padding: 0 !important;
    overflow: hidden;
  }

  .sermon-count {
    font-weight: bold;
    margin-bottom: 10px;
    text-align: center;
  }
</style>

<div class="container my-5">
  <h3 class="text-center mb-4 text-primary fw-bold">Watch Our Latest Messages</h3>

  <!-- Filter Controls -->
  <div class="filter-controls">
    <input type="text" id="searchInput" placeholder="Search by title...">
    <select id="filterPreacher">
      <option value="">All Preachers</option>
      <option value="Minister JB">Minister JB</option>
      <option value="Pastor">Pastor</option>
    </select>
    <button onclick="resetFilters()" class="btn btn-outline-primary">Reset Filters</button>
  </div>

  <!-- Sermon Count -->
  <div class="sermon-count" id="sermonCount">Showing 0 sermons</div>

  <!-- Sermon Videos -->
  <div class="row g-4" id="sermonContainer">

    <!-- Sermon 1 -->
    <div class="col-md-6 col-lg-3 sermon-card" data-title="God is God of standards" data-preacher="Pastor" data-aos="fade-up">
      <div class="card shadow-sm h-100">
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/9N5PyidHsTA" title="God is God of standards" allowfullscreen></iframe>
        </div>
        <div class="card-body">
          <h5 class="card-title text-primary">God is God of standards</h5>
          <p class="card-text small">Celebrate the joy of the Lord through powerful praise and worship.</p>
        </div>
      </div>
    </div>

    <!-- Sermon 2 -->
    <div class="col-md-6 col-lg-3 sermon-card" data-title="The Reason Why We Give" data-preacher="Minister JB" data-aos="fade-up">
      <div class="card shadow-sm h-100">
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/vHJsKkKQH18" title="The Reason Why We Give" allowfullscreen></iframe>
        </div>
        <div class="card-body">
          <h5 class="card-title text-primary">The Reason Why We Give</h5>
          <p class="card-text small">By Minister JB</p>
        </div>
      </div>
    </div>

    <!-- Sermon 3 -->
    <div class="col-md-6 col-lg-3 sermon-card" data-title="Power of Prayer" data-preacher="Pastor" data-aos="fade-up">
      <div class="card shadow-sm h-100">
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/NgAYJu17giQ" title="Power of Prayer" allowfullscreen></iframe>
        </div>
        <div class="card-body">
          <h5 class="card-title text-primary">Power of Prayer</h5>
          <p class="card-text small">Discover how prayer can transform your life through this inspiring sermon.</p>
        </div>
      </div>
    </div>

    <!-- Sermon 4 -->
    <div class="col-md-6 col-lg-3 sermon-card" data-title="Sina cha kukurudishia" data-preacher="Pastor" data-aos="fade-up">
      <div class="card shadow-sm h-100">
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/2tHkkhg1e6g" title="Sina cha kukurudishia" allowfullscreen></iframe>
        </div>
        <div class="card-body">
          <h5 class="card-title text-primary">Sina cha kukurudishia</h5>
          <p class="card-text small">Get uplifted midweek with this short word of encouragement from our pastor.</p>
        </div>
      </div>
    </div>

  </div>
</div>

<!-- Scripts -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
  AOS.init();

  const searchInput = document.getElementById('searchInput');
  const filterPreacher = document.getElementById('filterPreacher');
  const sermonCards = document.querySelectorAll('.sermon-card');
  const sermonCount = document.getElementById('sermonCount');

  function filterSermons() {
    const search = searchInput.value.toLowerCase();
    const preacher = filterPreacher.value;
    let visible = 0;

    sermonCards.forEach(card => {
      const title = card.dataset.title.toLowerCase();
      const cardPreacher = card.dataset.preacher;

      const matchesSearch = title.includes(search);
      const matchesPreacher = preacher === "" || cardPreacher === preacher;

      if (matchesSearch && matchesPreacher) {
        card.classList.remove('hide');
        visible++;
      } else {
        card.classList.add('hide');
      }
    });

    sermonCount.textContent = `Showing ${visible} sermon${visible === 1 ? '' : 's'}`;
  }

  function resetFilters() {
    searchInput.value = '';
    filterPreacher.value = '';
    filterSermons();
  }

  searchInput.addEventListener('input', filterSermons);
  filterPreacher.addEventListener('change', filterSermons);

  // On load
  filterSermons();
</script>

<?php include('includes/footer.php'); ?>
